﻿//INK
// Licence: GPL <http://www.gnu.org/licenses/gpl.html>
//------------------------------------------------------------------------------
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

var InkPrinter = {
	//since the order of the properties we are adding might vary,
	//let's build the xml object only on print()
	xml:{},
	init:function( v ) {
		var mainNodeStr = '<Ink v="' + v.toString() + '"></Ink>';
		InkPrinter.xml = new XML(mainNodeStr);
	},
	appendXML:function( xmlNode )
	{
		InkPrinter.xml.appendChild( xmlNode );	
	},
	printXML:function() 
	{
		var myPath    = Folder.desktop + "/" + activeDocument.name.replace(/\.[^\.]+$/, '') + "_details.xml";
		var file      = new File(myPath);
		file.encoding = "UTF8"; 
		file.open("w", "TEXT", "????"); 
		// unicode signature, this is UTF16 but will convert to UTF8 "EF BB BF" 
		file.write("\uFEFF"); 
		file.write(InkPrinter.xml.toXMLString()); 
		file.close(); 
	}
}